<?php

return [
    'auto_load_migrations' => true,

    'repository' => \Mtc\VehicleValuation\ValuationRepository::class,
    'max_request_age' => 30,

    /*
    |--------------------------------------------------------------------------
    |  Drivers
    |--------------------------------------------------------------------------
    |
    | Drivers that provide valuation functionality
    |
    */
    'drivers' => [
        'cap' => [
            'config' => \Mtc\VehicleValuation\Config\CapConfig::class,
            'class' => \Mtc\VehicleValuation\CapData::class,
            'subscriber_id' => env('CAP_SUBSCRIBER_ID'),
            'password' => env('CAP_PASSWORD'),
        ],
        'auto-trader' => [
            'config' => \Mtc\VehicleValuation\Config\AutoTraderConfig::class,
            'class' => \Mtc\VehicleValuation\AutoTrader::class,
            'api_key' => env('AUTO_TRADER_API_KEY'),
            'api_secret' => env('AUTO_TRADER_API_SECRET'),
            'valuation_api_key' => env('AUTO_TRADER_VALUATION_API_KEY'),
            'valuation_api_secret' => env('AUTO_TRADER_VALUATION_API_SECRET'),
            'merchant_id' => env('AUTO_TRADER_API_MERCHANT_ID'),
            'live' => env('AUTO_TRADER_USE_LIVE_API', true),
        ],
        'bca' => [
            'config' => \Mtc\VehicleValuation\Config\BCAConfig::class,
            'class' => \Mtc\VehicleValuation\BCA::class,
            'api_key' => env('BCA_API_KEY'),
            'api_secret' => env('BCA_API_SECRET'),
            'live' => env('BCA_LIVE_API', true),
            'location' =>  env('BCA_ORDERCONFIRMATION_LOCATION', ''),
        ],
        'motor-check' => [
            'client_id' => env('MOTORCHECK_CLIENT_ID'),
            'client_secret' => env('MOTORCHECK_CLIENT_SECRET'),
            // possible value vip
            'driver' => env('MOTORCHECK_DRIVER','auto-trader')
        ],
        'beep-beep' => [
            'config' => \Mtc\VehicleValuation\Config\BeepBeepConfig::class,
            'class' => \Mtc\VehicleValuation\BeepBeep::class,
            'api_key' => env('BEEP_BEEP_API_KEY')
        ],
        'goodbye-car' => [
            'class' => \Mtc\VehicleValuation\GoodbyeCar::class,
            'config' => \Mtc\VehicleValuation\Config\GoodbyeCarConfig::class,
            'api_key' => env('GOODBYE_CAR_VALUATION_API_KEY'),
        ],
        'eva' => [
            'class' => \Mtc\VehicleValuation\EVA::class,
            'config' => \Mtc\VehicleValuation\Config\EVAConfig::class,
        ],
        'hpi' => [
            'class' => \Mtc\VehicleValuation\HPI::class,
            'config' => \Mtc\VehicleValuation\Config\HPIConfig::class,
        ],
    ],
];
