# Plugin Updater Setup

This plugin uses a custom updater to check for updates from your Satis repository instead of WordPress.org.

## How It Works

1. **WordPress Admin Checks for Updates**: The plugin hooks into WordPress's `pre_set_site_transient_update_plugins` filter
2. **Queries Satis p2 API**: Fetches update info from `https://composer.mtcassets.com/p2/mtcmedia/wordpress-mtc-admin-auth.json`
3. **Parses Package Data**: Finds the latest stable version from the Satis packages array
4. **Displays Update in Admin**: If a newer version exists, WordPress shows an update notification
5. **Downloads from Satis**: WordPress downloads the ZIP file from the Satis `dist.url`
6. **Updates Plugin**: Standard WordPress update process

**No manual JSON files needed!** The updater reads directly from Satis's auto-generated p2 metadata.

## Setting Up Your Satis Repository

### 1. Satis Configuration

Your `satis.json` should include:

```json
{
  "name": "MTC Private Packages",
  "homepage": "https://composer.mtcassets.com",
  "repositories": [
    {
      "type": "vcs",
      "url": "https://bitbucket.org/your-org/mtc-admin-auth.git"
    }
  ],
  "require": {
    "mtcmedia/wordpress-mtc-admin-auth": "*"
  },
  "archive": {
    "directory": "dist",
    "format": "zip",
    "prefix-url": "https://composer.mtcassets.com",
    "skip-dev": true
  }
}
```

### 2. Build Satis

After tagging a new version:

```bash
# Tag the release
git tag -a v0.2.0 -m "Release 0.2.0"
git push --tags

# Build Satis (generates p2 JSON and ZIP files automatically)
php bin/satis build satis.json public/

# That's it! Satis automatically creates the p2 API endpoint
```

## Releasing New Versions

Follow this workflow to release a new version:

### Step-by-Step Release Process

**1. Update Version in Code**

Edit `mtc-admin-auth.php` (line 6) and change the version number:
```php
* Version: 1.1.0  // Change from 1.0.0 to 1.1.0
```

**2. Commit the Version Change**
```bash
git commit -am "Bump version to 1.1.0"
```

**3. Create Git Tag**

The tag should match the version number (with `v` prefix):
```bash
git tag -a v1.1.0 -m "Release 1.1.0"
```

**4. Push to Bitbucket**

Push both the commit and the tag:
```bash
git push origin master
git push origin --tags
```

**5. Rebuild Satis**

On your Satis server, rebuild the repository:
```bash
php bin/satis build satis.json public/
```

**6. Verify Update Appears**

WordPress sites will automatically detect the update within 12 hours, or you can force a check by:
- Deleting the transient: `delete_transient('mtc_plugin_update_mtc-admin-auth')`
- Going to Dashboard → Updates in WordPress admin

### Important Notes

- **Version in code must match git tag** (minus the `v` prefix)
  - Code: `Version: 1.1.0`
  - Tag: `v1.1.0`
- Use semantic versioning: `MAJOR.MINOR.PATCH` (e.g., 1.0.0, 1.1.0, 2.0.0)
- Satis parses the git tags to determine available versions
- WordPress compares installed version vs. latest Satis version

## Testing

To test the updater:

1. Install plugin version 0.1.0
2. Release version 0.2.0 following steps above
3. In WordPress admin, go to **Dashboard → Updates**
4. Plugin should show update available
5. Click "Update Now" - should download and install from Satis

## Troubleshooting

**Update Not Showing:**
- Check transient cache: `delete_transient('mtc_plugin_update_mtc-admin-auth')`
- Verify p2 JSON is accessible: `https://composer.mtcassets.com/p2/mtcmedia/wordpress-mtc-admin-auth.json`
- Check version comparison: new version must be higher than current
- Ensure Satis build completed successfully

**Download Fails:**
- Verify ZIP file exists at `download_url` in `info.json`
- Check file permissions on Satis server
- Ensure URL is publicly accessible

**Enable Debug Logging:**
```php
define('WP_DEBUG', true);
define('WP_DEBUG_LOG', true);
```
Check `wp-content/debug.log` for updater errors.
