# MTC Admin Authentication

**Version**: 1.1.2
**Author**: MTC Media
**Requires WordPress**: 5.0+
**Requires PHP**: 7.4+

## Overview

The MTC Admin Authentication plugin enables MTC Media staff to authenticate to WordPress sites using their MTC email addresses and one-time passwords (OTP) validated against a centralized authentication API.

## Features

- **OTP-Based Authentication**: MTC staff log in using email + OTP instead of passwords
- **Automatic User Management**: Creates and manages shared "mtcadmin" administrator account
- **CSRF Protection**: Secure login forms with token validation
- **Audit Logging**: Comprehensive logging of all authentication attempts
- **Session Management**: 24-hour session timeout with metadata tracking
- **Fail-Secure**: All error conditions deny access (no false positives)
- **WordPress Compatibility**: Non-MTC users continue using standard authentication

## Installation

### Manual Installation

1. Upload the `mtc-admin-auth` folder to `/wp-content/plugins/`
2. Activate the plugin through the 'Plugins' menu in WordPress
3. No configuration required - the plugin works immediately

### WordPress Admin Upload

1. Navigate to **Plugins → Add New → Upload Plugin**
2. Choose the `mtc-admin-auth.zip` file
3. Click **Install Now** and then **Activate Plugin**

## Usage

### For MTC Staff

1. Navigate to the WordPress login page: `https://yoursite.com/wp-admin/`
2. **Username**: Enter your MTC email address (e.g., `yourname@mtc.co.uk`)
3. **Password**: Enter your OTP code (obtained from MTC authentication system)
4. Click **Log In**
5. You will be logged in as "mtcadmin" with full administrator privileges

### Important Notes

- **Never enter "mtcadmin" as your username** - Always use your personal MTC email address
- **OTP codes are single-use** - Each code can only be used once
- **Sessions expire after 24 hours** - You will need to re-authenticate with a new OTP
- **Password recovery is disabled** for the mtcadmin account (security feature)

## Technical Details

### Authentication Flow

1. Plugin intercepts login attempts via `authenticate` filter (priority 10)
2. Detects MTC email addresses (@mtc.co.uk or @mtcmedia.co.uk legacy)
3. Validates OTP against `https://projects.mtcmedia.co.uk/api/vcs/admin-access-check`
4. Creates/updates mtcadmin user with randomly generated password
5. Establishes WordPress session and stores audit metadata
6. Redirects to WordPress admin dashboard

### Security Features

- **CSRF Token Validation**: All login forms protected
- **Password Rotation**: mtcadmin password regenerated on every login
- **Direct Login Prevention**: Username "mtcadmin" is blocked
- **Redirect Validation**: Prevents open redirect vulnerabilities
- **Input Sanitization**: All user inputs sanitized
- **SQL Injection Protection**: Prepared statements for all database queries
- **Audit Logging**: Complete trail of authentication attempts

### Database Tables

The plugin creates one custom table:

- **wp_mtc_auth_logs**: Stores authentication attempts with timestamp, email, IP, success status, and error messages

### User Metadata

The mtcadmin user stores session metadata:

- `mtcadmin_source_email`: Email of currently/last authenticated staff member
- `last_login`: Timestamp of last successful login
- `mtcadmin_login_count`: Total number of successful logins
- `mtcadmin_session_expires`: Unix timestamp when session expires

## Troubleshooting

### "Invalid OTP code" Error

- **Cause**: OTP is incorrect, expired, or already used
- **Solution**: Request a new OTP and try again

### "Unable to reach authentication service" Error

- **Cause**: OTP validation API is temporarily unavailable
- **Solution**: Wait a few minutes and try again, or contact MTC IT support

### "Direct 'mtcadmin' login is not permitted" Error

- **Cause**: You tried to log in with username "mtcadmin"
- **Solution**: Use your personal MTC email address instead

### Standard WordPress Users Cannot Log In

- **Cause**: Plugin may be interfering with standard authentication
- **Solution**: Contact plugin developer - this should not happen

## Requirements

- WordPress 5.0 or higher
- PHP 7.4 or higher
- cURL or PHP streams for API requests
- HTTPS recommended for secure cookies
- Access to projects.mtcmedia.co.uk API from WordPress server

## Support

For technical support or bug reports:
- **Email**: craig@mtc.co.uk

## Changelog

### 1.0.0 - 2025-10-13

- Initial release
- OTP-based authentication for MTC staff
- Automatic mtcadmin user management
- CSRF protection
- Audit logging
- Session management (24-hour timeout)
- Graceful API failure handling
- WordPress authentication passthrough
