<?php

namespace Mtc\WorldPay\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\URL;
use Mtc\Checkout\Contracts\InvoiceRepositoryContract;
use Mtc\Checkout\Facades\Payment;

/**
 * Class WorldPayController
 *
 * @package Mtc\WorldPay
 */
class WorldPayController extends Controller
{
    /**
     * Payment authorization page
     *
     * @param Request $request
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\Http\RedirectResponse|\Illuminate\View\View
     */
    public function return(Request $request, $invoice_id, InvoiceRepositoryContract $invoice_repository)
    {
        $invoice_repository->load($invoice_id);
        $paid = $invoice_repository->isPaid();
        if ($paid) {
            return redirect()->to(URL::signedRoute('successful_payment', ['id' => $invoice_id ], null, config('app.env') === 'production'));
        }

        if ($this->shouldProcessAsPaid($request)) {

            $request->merge([
                'amount' => $invoice_repository->getOutstandingAmount(),
                'transId' => $request->input('orderKey'),
            ]);

            try {
                Payment::setActiveDriver('worldpay');
                $payment_details = Payment::charge($request, $invoice_repository);
                $invoice_repository->savePayment($payment_details);
                return redirect()->to(URL::signedRoute('successful_payment', ['id' => $invoice_id ], null, config('app.env') === 'production'));

            } catch (\Exception $exception) {
                return redirect()->to(route('failed_payment'));
            }
        }
        return redirect()->to(route('failed_payment'));
    }

    /**
     * Check if we can mark order as paid
     *
     * @param Request $request
     * @return bool
     */
    protected function shouldProcessAsPaid(Request $request)
    {
        return $request->input('paymentStatus') === 'AUTHORISED'
            && config('worldpay.order_key_string')
            && strpos($request->input('orderKey'), config('worldpay.order_key_string')) !== false;

    }
}
