<?php

namespace Mtc\WorldPay\Providers;

use Illuminate\Support\Facades\Event;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\ServiceProvider;
use Mtc\Checkout\Events\AddPaymentGatewayScripts;
use Mtc\WorldPay\Listeners\AddWorldPayExternalScripts;
use Mtc\WorldPay\WorldPay;

/**
 * Class WorldPayServiceProvider
 *
 * @package Mtc\WorldPay\Providers
 */
class WorldPayServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap the application services.
     */
    public function boot()
    {
        if (config('worldpay.enabled', false) ===  false) {
            return;
        }

        app('twig_loader')->addPath(dirname(__DIR__, 2) . '/resources/templates');
        $this->loadTranslationsFrom(dirname(__DIR__, 2) . '/resources/lang', 'worldpay');
        Route::middleware('api')->group(dirname(__DIR__, 2) . '/routes/api.php');
        Route::middleware('web')->group(dirname(__DIR__, 2) . '/routes/web.php');

        $this->app['payment']->extend('worldpay', function($app) {
            return new WorldPay();
        });

        if (!$this->app->runningInConsole()) {
            Event::listen(AddPaymentGatewayScripts::class, AddWorldPayExternalScripts::class);
        }
    }

    /**
     * Register the application services.
     */
    public function register()
    {
        // Automatically apply the package configuration
        $this->mergeConfigFrom(dirname(__DIR__, 2) . '/config/worldpay.php', 'worldpay');

    }

}
