<?php
/**
 * Copyright (C) 2022 Novuna Consumer Finance
 * All rights reserved. See LICENCE.pdf for details
 */
declare(strict_types=1);

namespace Novuna\Pbf\Api;

use Novuna\Pbf\Api\Data\ScriptTagDataInterface;

/**
 * @api
 */
interface CmsPageInterface
{
    /**
     * Query to get CMS page by handle - workarounds M2 unable to load CMS page per store
     * @param string $handle
     * @return \Novuna\Pbf\Api\Data\CmsPageWrapperInterface|null
     * @throws \Magento\Framework\Webapi\Exception
     * @throws \Magento\Framework\Exception\StateException
     */
    public function getByHandle(string $handle): ?\Novuna\Pbf\Api\Data\CmsPageWrapperInterface;

    /**
     * Query to get CMS page by handle - workarounds M2 unable to load CMS page per store
     * @return \Novuna\Pbf\Api\Data\CmsPageWrapperInterface|null
     * @throws \Magento\Framework\Webapi\Exception
     * @throws \Magento\Framework\Exception\StateException
     */
    public function getAllPagesForStore(): ?\Novuna\Pbf\Api\Data\CmsPageWrapperInterface;
}
