<?php

/**
 * Copyright (C) 2022 Novuna Consumer Finance
 * All rights reserved. See LICENCE.pdf for details
 */

declare(strict_types=1);

namespace Novuna\Pbf\Api\Data;

interface CmsPageDataInterface
{
    /**
     * Gets the CMS Page ID
     * @return int|null Page ID
     */
    public function getId();

    /**
     * Sets the Page ID
     * @param int $id Page ID
     * @return $this
     */
    public function setId(int $id);

    /**
     * Gets the CMSPage identifier
     * @return ?string
     */
    public function getIdentifier(): ?string;

    /**
     * Sets the CMSPage identifier
     * @param ?string $identifier
     * @return $this
     */
    public function setIdentifier(?string $identifier);

    /**
     * Gets the CMSPage topic
     * @return ?string CMSPage topic
     */
    public function getTitle(): ?string;

    /**
     * Sets the CMSPage title
     * @param ?string $title Webhook title
     * @return $this
     */
    public function setTitle(?string $title);

    /**
     * Gets the CMSPage content
     * @return ?string content
     */
    public function getContent(): ?string;

    /**
     * Sets the CMSPage content
     * @param ?string $content CMSPage content
     * @return $this
     */
    public function setContent(?string $content);

    /**
     * Gets CMSPage active
     * @return boolean
     */
    public function isActive(): bool;

    /**
     * Sets CMSPage active
     * @param boolean $active
     * @return $this
     */
    public function setActive(bool $active);
}
