<?php
/**
 * Copyright (C) 2022 Novuna Consumer Finance
 * All rights reserved. See LICENCE.pdf for details
 */
declare(strict_types=1);

namespace Novuna\Pbf\Api\Data;

interface DraftOrderDataInterface
{
    const ID = 'id';
    const ORDER_ID = 'order_id';
    const QUOTE_ID = 'quote_id';
    const FINANCE_AMOUNT = 'finance_amount';
    const PBF_TAKING_DEPOSIT = 'pbf_taking_deposit';
    const ADDRESS = 'address';
    const APPLICATION_NUMBER_FIELD = 'pbf_application_number'; //Field name of application number
    const FINANCE_STATE_RO_FIELD = 'pbf_state_ro'; //Field name of finance state

    /**
     *
     * @return int|null Comment.
     */
    public function getId(): ?int;

    /**
     * @param int $id id
     * @return $this
     */
    public function setId($id);

    /**
     * @return int|null
     */
    public function getOrderId(): ?int;

    /**
     * @param int $orderId id
     * @return $this
     */
    public function setOrderId($orderId);

    /**
     * @return string|null
     */
    public function getReservedOrderId(): ?string;

    /**
     * @return string|null
     */
    public function getName(): ?string;

    /**
     * @param string $draftName
     * @return $this
     */
    public function setName($draftName);

    /**
     * @return int|null
     */
    public function getQuoteId(): ?int;

    /**
     * @param int $quoteId id
     * @return $this
     */
    public function setQuoteId($quoteId);

    /**
     * @return string
     */
    public function getPayDepositUrl(): string;

    /**
     * @return string
     */
    public function getEmail(): ?string;

    /**
     * @return float|null
     */
    public function getShippingTotal(): ?float;

    /**
     * @return float|null
     */
    public function getSubTotalInclTax(): ?float;

    /**
     * @return float|null
     */
    public function getFinanceAmount(): ?float;

    /**
     * @return int
     */
    public function getDepositCaptureType(): int;

    /**
     * @return float|null
     */
    public function getTotal(): ?float;

    /**
     * @return \Magento\Quote\Api\Data\AddressInterface
     */
    public function getAddress(): \Magento\Quote\Api\Data\AddressInterface;

    /**
     * @return \Magento\Quote\Api\Data\AddressInterface
     */
    public function setAddress(\Magento\Quote\Api\Data\AddressInterface $address);

    /**
     * @return \Magento\Quote\Api\Data\AddressInterface
     */
    public function getShippingAddress(): \Magento\Quote\Api\Data\AddressInterface;

    /**
     * @return \Magento\Quote\Api\Data\AddressInterface
     */
    public function getBillingAddress(): \Magento\Quote\Api\Data\AddressInterface;

    /**
     * @return \Magento\Quote\Api\Data\CartItemInterface[]
     */
    public function getLineItems(): ?array;
}
