<?php
/**
 * Copyright (C) 2022 Novuna Consumer Finance
 * All rights reserved. See LICENCE.pdf for details
 */
declare(strict_types=1);

namespace Novuna\Pbf\Api\Data;

interface OrderMetaFieldDataInterface
{
    /**
     * Gets the order meta field ID
     *
     * @return int|null Comment.
     */
    public function getId(): ?int;

    /**
     * Sets the ID of meta field
     * @param int $id id
     * @return $this
     */
    public function setId($id);

    /**
     * Sets the order ID of meta field
     * @param int $orderId id
     * @return $this
     */
    public function setOrderId($orderId);

    /**
     * Sets the quote ID of meta field
     * @param int $quoteId id
     * @return $this
     */
    public function setQuoteId($quoteId);

    /**
     * Gets the order meta tag key
     *
     * @return string|null Comment.
     */
    public function getKey(): ?string;

    /**
     * Sets the key of meta field
     * @param string $key
     * @return $this
     */
    public function setKey($key);

    /**
     * Gets the order meta field value
     *
     * @return string|null Comment.
     */
    public function getValue(): ?string;

    /**
     * Sets the value of order meta field
     * @param string $value
     * @return $this
     */
    public function setValue($value);
}
