<?php
/**
 * Copyright (C) 2022 Novuna Consumer Finance
 * All rights reserved. See LICENCE.pdf for details
 */
declare(strict_types=1);

namespace Novuna\Pbf\Api\Data;

interface OrderRiskDataInterface
{
    /**
     * Gets the order risk ID
     *
     * @return int|null Comment.
     */
    public function getId(): ?int;

    /**
     * Sets the ID of risk
     * @param int $id id
     * @return $this
     */
    public function setId($id);

    /**
     * Sets the order ID of Risk
     * @param int $orderId id
     * @return $this
     */
    public function setOrderId($orderId);

    /**
     * Gets the order ID of Risk
     * @return int
     */
    public function getOrderId():int;

    /**
     * Gets the risk message
     *
     * @return string Comment.
     */
    public function getMessage(): string;

    /**
     * Sets the risk message
     * @param string $message
     * @return $this
     */
    public function setMessage($message);

    /**
     * Gets the risk recommendation  message
     *
     * @return string Comment.
     */
    public function getRecommendation(): string;

    /**
     * Sets the risk recommendation message
     * @param string $recommendation
     * @return $this
     */
    public function setRecommendation($recommendation);

    /**
     * Gets the risk score
     *
     * @return float Comment.
     */
    public function getScore(): float;

    /**
     * Sets the risk score
     * @param float $score
     * @return $this
     */
    public function setScore($score);
}
