<?php
/**
 * Copyright (C) 2022 Novuna Consumer Finance
 * All rights reserved. See LICENCE.pdf for details
 */
declare(strict_types=1);

namespace Novuna\Pbf\Api\Data;

interface ScriptTagDataInterface
{

    /**
     * Gets the created-at timestamp for the script tag
     *
     * @return string|null Created-at timestamp.
     */
    public function getCreatedAt(): ?string;

    /**
     * Sets the created-at timestamp for the script tag
     *
     * @param string $createdAt timestamp
     * @return $this
     */
    public function setCreatedAt($createdAt);

    /**
     * Gets the event name for script tag create
     *
     * @return string|null Comment.
     */
    public function getEvent(): ?string;

    /**
     * Sets the event name for script tag create
     * @param string|null $event event
     * @return $this
     */
    public function setEvent($event);

    /**
     * Gets the script tag src
     *
     * @return string|null Comment.
     */
    public function getSrc(): ?string;

    /**
     * Sets the src of script tag
     * @param string $src src
     * @return $this
     */
    public function setSrc($src);

    /**
     * Gets the script tag ID
     *
     * @return int|null Comment.
     */
    public function getId(): ?int;

    /**
     * Sets the ID of script tag
     * @param int $id id
     * @return $this
     */
    public function setId($id);
}
