<?php

/**
 * Copyright (C) 2022 Novuna Consumer Finance
 * All rights reserved. See LICENCE.pdf for details
 */

declare(strict_types=1);

namespace Novuna\Pbf\Api\Data;

interface WebhookDataInterface
{
    /**
     * Gets the webhook ID
     * @return string|null Webhook ID
     */
    public function getId();

    /**
     * Sets the webhook ID
     * @param int $id Webhook ID
     * @return $this
     */
    public function setId(int $id);

    /**
     * Gets the webhook name
     * @return ?string
     */
    public function getName(): ?string;

    /**
     * Sets the webhook name
     * @param ?string $name
     * @return $this
     */
    public function setName(?string $name);

    /**
     * Gets the webhook topic
     * @return ?string Webhook topic
     */
    public function getTopic(): ?string;

    /**
     * Sets the webhook topic, should be one of: order created, order cancelled, order shipped, order updated
     * @param ?string $topic Webhook topic
     * @return $this
     */
    public function setTopic(?string $topic);

    /**
     * Gets the webhook delivery target URL
     * @return ?string Webhook delivery target URL
     */
    public function getDeliveryUrl(): ?string;

    /**
     * Sets the webhook delivery target URL
     * @param ?string $deliveryUrl Webhook delivery target URL
     * @return $this
     */
    public function setDeliveryUrl(?string $deliveryUrl);

    /**
     * Gets the secret used for signing webhook messages
     * @return ?string
     */
    public function getSecret(): ?string;

    /**
     * Sets the secret used for signing webhook messages
     * @param ?string $secret
     * @return $this
     */
    public function setSecret(?string $secret);
}
