<?php
/**
 * Copyright (C) 2022 Novuna Consumer Finance
 * All rights reserved. See LICENCE.pdf for details
 */
declare(strict_types=1);

namespace Novuna\Pbf\Api;

use Novuna\Pbf\Api\Data\CommentWrapperInterface;

/**
 * @api
 */
interface DraftOrderInterface
{
    /**
     * POST request to create draft order
     * @param string $quoteIdMasked
     * @param float $shippingPrice
     * @param float $pbfTakingDeposit
     * @return \Novuna\Pbf\Api\Data\DraftOrderWrapperInterface|null
     * @throws \Magento\Framework\Webapi\Exception
     * @throws \Magento\Framework\Exception\StateException
     */
    public function createDraftOrder(
        string $quoteIdMasked,
        float $shippingPrice,
        bool $pbfTakingDeposit
    ): ?\Novuna\Pbf\Api\Data\DraftOrderWrapperInterface;

    /**
     * POST request to create draft order
     * @param string $quoteIdMasked
     * @return \Novuna\Pbf\Api\Data\DraftOrderWrapperInterface|null
     * @throws \Magento\Framework\Webapi\Exception
     * @throws \Magento\Framework\Exception\StateException
     */
    public function convertDraftOrder(
        string $quoteIdMasked
    ): ?\Novuna\Pbf\Api\Data\DraftOrderWrapperInterface;

    /**
     * Query to get meta fields from given draft order
     * @param string $quoteIdMasked
     * @return \Novuna\Pbf\Api\Data\DraftOrderWrapperInterface|null
     * @throws \Magento\Framework\Webapi\Exception
     * @throws \Magento\Framework\Exception\StateException
     */
    public function getDraftOrder(
        string $quoteIdMasked
    ): ?\Novuna\Pbf\Api\Data\DraftOrderWrapperInterface;

    /**
     * Query to get meta fields from given draft order
     * @param string $quoteIdMasked
     * @return \Novuna\Pbf\Api\Data\DraftOrderWrapperInterface|null
     * @throws \Magento\Framework\Webapi\Exception
     * @throws \Magento\Framework\Exception\StateException
     */
    public function reserveOrderId(
        string $quoteIdMasked
    ): ?string;

    /**
     * Find Draft order by Order ID
     * @param int $orderId
     * @return \Novuna\Pbf\Api\Data\DraftOrderWrapperInterface|null
     * @throws \Magento\Framework\Webapi\Exception
     * @throws \Magento\Framework\Exception\StateException
     */
    public function getByOrder(
        int $orderId
    ): ?\Novuna\Pbf\Api\Data\DraftOrderWrapperInterface;

    /**
     * Update address of a specified draft order.
     *
     * @param string $quoteIdMasked The quote ID.
     * @param \Magento\Quote\Api\Data\AddressInterface $orderAddress
     * @return bool
     */
    public function updateAddresses(
        string $quoteIdMasked,
        \Magento\Quote\Api\Data\AddressInterface $orderAddress
    ): bool;

    /**
     * Adds a comment to a specified draft order.
     *
     * @param int $id The quote ID.
     * @param \Magento\Sales\Api\Data\OrderStatusHistoryInterface[] $statusHistoryItems Status history comment.
     * @return bool
     */
    public function addComment($id, $statusHistoryItems);

    /**
     * Get a comments of a specified draft order.
     *
     * @param int $id The quote ID.
     * @return \Novuna\Pbf\Api\Data\CommentWrapperInterface
     */
    public function getComments($id);

}
