<?php
/**
 * Copyright (C) 2022 Novuna Consumer Finance
 * All rights reserved. See LICENCE.pdf for details
 */
declare(strict_types=1);

namespace Novuna\Pbf\Api;

/**
 * Search criteria interface.
 *
 * @api
 * @since 100.0.2
 */
interface OrderMetaFieldSearchCriteriaInterface
{
    /**
     * Get search Key
     *
     * @return string|null
     */
    public function getKey(): ?string;

    /**
     * Set page size.
     *
     * @param string $key
     * @return $this
     */
    public function setKey($key);
}
