<?php
/**
 * Copyright (C) 2022 Novuna Consumer Finance
 * All rights reserved. See LICENCE.pdf for details
 */
declare(strict_types=1);

namespace Novuna\Pbf\Api;

use Magento\Framework\Webapi\Exception as WebapiException;

/**
 * @api
 */
interface OrderMetaFieldsInterface
{
    /**
     * POST request to create meta fields on given order
     * @param int $orderId
     * @param \Novuna\Pbf\Api\Data\OrderMetaFieldDataInterface $metaField
     * @return \Novuna\Pbf\Api\Data\OrderMetaFieldWrapperInterface|null
     * @throws \Magento\Framework\Webapi\Exception
     * @throws \Magento\Framework\Exception\StateException
     */
    public function createMetaFields(
        int $orderId,
        \Novuna\Pbf\Api\Data\OrderMetaFieldDataInterface $metaField
    ): ?\Novuna\Pbf\Api\Data\OrderMetaFieldWrapperInterface;

    /**
     * @param string $quoteIdMasked
     * @param \Novuna\Pbf\Api\Data\OrderMetaFieldDataInterface $metaField
     * @return \Novuna\Pbf\Api\Data\OrderMetaFieldWrapperInterface|null
     * @throws WebapiException
     */
    public function createDraftOrderMetaFields(
        string $quoteIdMasked,
        \Novuna\Pbf\Api\Data\OrderMetaFieldDataInterface $metaField
    ): ?\Novuna\Pbf\Api\Data\OrderMetaFieldWrapperInterface;

    /**
     * @param string $quoteIdMasked
     * @param \Novuna\Pbf\Api\Data\SetOrderFinanceStateInputInterface $input
     * @return bool not used, M2 requires some return type otherwise it crashes
     * @throws WebapiException
     */
    public function setDraftOrderFinanceState(
        string $quoteIdMasked,
        \Novuna\Pbf\Api\Data\SetOrderFinanceStateInputInterface $input
    ):bool;

    /**
     * @param int $orderId
     * @param \Novuna\Pbf\Api\Data\SetOrderFinanceStateInputInterface $input
     * @return bool not used, M2 requires some return type otherwise it crashes
     * @throws WebapiException
     */
    public function setOrderFinanceState(
        int $orderId,
        \Novuna\Pbf\Api\Data\SetOrderFinanceStateInputInterface $input
    ):bool;

    /**
     * Query to get meta fields from given order
     * @param int $orderId
     * @param string|null $key
     * @return \Novuna\Pbf\Api\Data\OrderMetaFieldWrapperInterface|null
     * @throws \Magento\Framework\Webapi\Exception
     * @throws \Magento\Framework\Exception\StateException
     */
    public function getMetaFields(
        int $orderId,
        string $key = null
    ): ?\Novuna\Pbf\Api\Data\OrderMetaFieldWrapperInterface;

    /**
     * @param string $quoteIdMasked
     * @param string|null $key
     * @return \Novuna\Pbf\Api\Data\OrderMetaFieldWrapperInterface|null
     * @throws WebapiException
     */
    public function getDraftOrderMetaFields(
        string $quoteIdMasked,
        string $key = null
    ): ?\Novuna\Pbf\Api\Data\OrderMetaFieldWrapperInterface;

    /**
     * @param int $metaFieldId
     * @return bool
     * @throws WebapiException
     */
    public function deleteMetaFields(int $metaFieldId): bool;

    /**
     * @param int $metaFieldId
     * @return bool
     * @throws WebapiException
     */
    public function deleteDraftOrderMetaFields(int $metaFieldId): bool;
}
