<?php
/**
 * Copyright (C) 2022 Novuna Consumer Finance
 * All rights reserved. See LICENCE.pdf for details
 */
declare(strict_types=1);

namespace Novuna\Pbf\Api;

use Novuna\Pbf\Api\Data\OrderMetaFieldDataInterface;
use Novuna\Pbf\Model\ResourceModel\SalesOrderMeta\Collection;

/**
 * CRUD interface.
 * @api
 * @since 100.0.2
 */
interface SalesOrderMetaRepositoryInterface
{

    /**
     * Save order meta field.
     *
     * @param \Novuna\Pbf\Api\Data\OrderMetaFieldDataInterface $orderMetaField
     * @return \Novuna\Pbf\Api\Data\OrderMetaFieldDataInterface
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function save(Data\OrderMetaFieldDataInterface $orderMetaField);

    /**
     * Retrieve orderMetaField.
     *
     * @param string $orderMetaFieldId
     * @return \Novuna\Pbf\Api\Data\OrderMetaFieldDataInterface
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function getById($metaFieldId);

    /**
     * Retrieve orderMetaField.
     *
     * @param int $orderId
     * @param string $metaFieldKey
     * @param string $type
     * @return \Novuna\Pbf\Api\Data\OrderMetaFieldDataInterface
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function getByMetaFieldKey(
        int $orderId,
        string $metaFieldKey,
        string $type = 'order'
    ): OrderMetaFieldDataInterface;

    /**
     * Retrieve orderMetaField.
     *
     * @param int $orderId
     * @param string|null $metaFieldKey
     * @param string $type
     * @return Collection
     */
    public function getMetFieldsCollection(
        int $orderId,
        string $metaFieldKey = null,
        string $type = 'order'
    ): Collection;

    /**
     * @return Collection
     */
    public function getCollection();

    /**
     * Retrieve orderMetaFields matching the specified criteria.
     *
     * @param \Magento\Framework\Api\SearchCriteriaInterface $searchCriteria
     * @return \Magento\Framework\Api\SearchResultsInterface
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function getList(\Magento\Framework\Api\SearchCriteriaInterface $searchCriteria);

    /**
     * Delete orderMetaField.
     *
     * @param \Novuna\Pbf\Api\Data\OrderMetaFieldDataInterface $orderMetaField
     * @return bool true on success
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function delete(Data\OrderMetaFieldDataInterface $orderMetaField);

    /**
     * Delete orderMetaField by ID.
     *
     * @param string $metaFieldId
     * @return bool true on success
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function deleteById($metaFieldId);
}
