<?php
/**
 * Copyright (C) 2022 Novuna Consumer Finance
 * All rights reserved. See LICENCE.pdf for details
 */
declare(strict_types=1);

namespace Novuna\Pbf\Api;

use Novuna\Pbf\Api\Data\ScriptTagDataInterface;

/**
 * @api
 */
interface ScriptTagInterface
{
    /**
     * POST request to create PBF widget script tag
     * @param \Novuna\Pbf\Api\Data\ScriptTagDataInterface $scriptTag Script tag input
     * @return \Novuna\Pbf\Api\Data\ScriptTagWrapperInterface|null
     * @throws \Magento\Framework\Webapi\Exception
     * @throws \Magento\Framework\Exception\StateException
     */
    public function createScriptTag(ScriptTagDataInterface $scriptTag): ?\Novuna\Pbf\Api\Data\ScriptTagWrapperInterface;

    /**
     * Query to get PBF widget script tag
     * @return \Novuna\Pbf\Api\Data\ScriptTagWrapperInterface|null
     * @throws \Magento\Framework\Webapi\Exception
     * @throws \Magento\Framework\Exception\StateException
     */
    public function getScriptTag(): ?\Novuna\Pbf\Api\Data\ScriptTagWrapperInterface;

    /**
     * @param int $scriptTagId
     * @return bool
     */
    public function deleteScriptTag($scriptTagId): bool;
}
