<?php

/**
 * Copyright (C) 2022 Novuna Consumer Finance
 * All rights reserved. See LICENCE.pdf for details
 */

declare(strict_types=1);

namespace Novuna\Pbf\Api;

use Novuna\Pbf\Api\Data\SettingsWrapperInterface;

/**
 * Settings api takes a doubly-encoded json string as M2 api generator cannot handle heterogeneous arrays
 * e.g.
 * ```
 * {
 *      "settings": "{ \"AbandonedHandbackPage\": \"test\" }"
 * }
 * ```
 * @api
 */
interface SettingsInterface
{
    /**
     * @param string $settings
     * @return string
     * @throws \Magento\Framework\Webapi\Exception
     * @throws \Magento\Framework\Exception\StateException
     */
    public function setSettings(string $settings): string;

    /**
     * @return \Novuna\Pbf\Api\Data\SettingsWrapperInterface
     * @throws \Magento\Framework\Webapi\Exception
     * @throws \Magento\Framework\Exception\StateException
     */
    public function getSettings(): SettingsWrapperInterface;
}
