<?php

/**
 * Copyright (C) 2022 Novuna Consumer Finance
 * All rights reserved. See LICENCE.pdf for details
 */

declare(strict_types=1);

namespace Novuna\Pbf\Api;

use Novuna\Pbf\Api\Data\WebhookDataInterface;
use Novuna\Pbf\Api\Data\WebhookWrapperInterface;

/**
 * @api
 */
interface WebhookInterface
{
    /**
     * Register a webhook
     * @param \Novuna\Pbf\Api\Data\WebhookDataInterface $webhook
     * @return \Novuna\Pbf\Api\Data\WebhookDataInterface
     * @throws \Magento\Framework\Webapi\Exception
     * @throws \Magento\Framework\Exception\StateException
     */
    public function createWebhook(WebhookDataInterface $webhook): WebhookDataInterface;

    /**
     * Query to get all registered webhooks
     * @return \Novuna\Pbf\Api\Data\WebhookWrapperInterface
     * @throws \Magento\Framework\Webapi\Exception
     * @throws \Magento\Framework\Exception\StateException
     */
    public function getWebhooks(): WebhookWrapperInterface;

    /**
     * Remove registered webhook
     * @param int $webhookId
     * @return bool
     */
    public function deleteWebhook(int $webhookId): bool;
}
