<?php
/**
 * Copyright (C) 2022 Novuna Consumer Finance
 * All rights reserved. See LICENCE.pdf for details
 */
declare(strict_types=1);

namespace Novuna\Pbf\Controller\Adminhtml\Configuration;

use Magento\Backend\App\Action\Context;
use Magento\Backend\Model\View\Result\Page;
use Magento\Framework\Phrase;
use Magento\Framework\View\Result\PageFactory;
use Novuna\Pbf\Model\StoreConfigProvider;

class Uninstall extends Base
{
    const ADMIN_RESOURCE = 'Novuna_Pbf::paybyfinance';
    private StoreConfigProvider $storeConfigProvider;
    private PageFactory $resultPageFactory;

    public function __construct(
        StoreConfigProvider $storeConfigProvider,
        PageFactory $resultPageFactory,
        Context $context
    ) {
        $this->storeConfigProvider = $storeConfigProvider;
        $this->resultPageFactory = $resultPageFactory;
        parent::__construct($context);
    }

    public function execute()
    {
        $result = $this->resultPageFactory->create();
        if ($result instanceof Page) {
            $result->setActiveMenu(self::ADMIN_RESOURCE);
            $result->getConfig()->getTitle()->prepend(new Phrase('PBF - UnInstall'));
        }

        return $result;
    }
}
