<?php

/**
 * Copyright (C) 2022 Novuna Consumer Finance
 * All rights reserved. See LICENCE.pdf for details
 */

declare(strict_types=1);

namespace Novuna\Pbf\Model\Api;

use Magento\Store\Model\StoreManagerInterface;
use Novuna\Pbf\Api\CmsPageInterface;
use Novuna\Pbf\Api\CmsPageRepositoryInterface;
use Novuna\Pbf\Api\Data\WebhookDataInterface;
use Novuna\Pbf\Api\Data\WebhookWrapperInterface;
use Novuna\Pbf\Api\WebhookInterface;
use Novuna\Pbf\Api\WebhookRepositoryInterface;
use Novuna\Pbf\Model\Data\CmsPageData;
use Novuna\Pbf\Model\Data\CmsPageWrapper;

class CmsPageService implements CmsPageInterface
{
    private CmsPageRepositoryInterface $cmsPageRepository;
    private StoreManagerInterface $storeManager;

    public function __construct(
        CmsPageRepositoryInterface $cmsPageRepository,
        StoreManagerInterface $storeManager,
    ) {
        $this->cmsPageRepository = $cmsPageRepository;
        $this->storeManager = $storeManager;
    }

    /**
     * @inheritDoc
     */
    public function getByHandle(string $handle): ?\Novuna\Pbf\Api\Data\CmsPageWrapperInterface{
        $storeId = $this->storeManager->getStore()->getId();
        return new CmsPageWrapper($this->cmsPageRepository->getByHandle($handle, $storeId));
    }

    /**
     * @inheritDoc
     */
    public function getAllPagesForStore(): ?\Novuna\Pbf\Api\Data\CmsPageWrapperInterface{
        $storeId = $this->storeManager->getStore()->getId();
        $pw = new CmsPageWrapper(null);
        $pw->setPages($this->cmsPageRepository->getAllPages($storeId));
        return $pw;
    }

}
