<?php
/**
 * Copyright (C) 2022 Novuna Consumer Finance
 * All rights reserved. See LICENCE.pdf for details
 */
declare(strict_types=1);

namespace Novuna\Pbf\Model\Config\Source;

use Magento\Framework\Option\ArrayInterface;

class Mode implements ArrayInterface
{
    /**
     * {@inheritdoc}
     */
    public function toOptionArray()
    {
        return [
            [
                'value' => \Novuna\Pbf\Model\StoreConfigProvider::MODE_TEST,
                'label' => __('Test'),
            ],
            [
                'value' => \Novuna\Pbf\Model\StoreConfigProvider::MODE_LIVE,
                'label' => __('Live')
            ]
        ];
    }
}
