<?php

/**
 * Copyright (C) 2022 Novuna Consumer Finance
 * All rights reserved. See LICENCE.pdf for details
 */

declare(strict_types=1);

namespace Novuna\Pbf\Model\Data;

use Novuna\Pbf\Api\Data\CmsPageDataInterface;
use Novuna\Pbf\Api\Data\CmsPageWrapperInterface;

/**
 * @api
 */
class CmsPageWrapper implements CmsPageWrapperInterface
{
    private $page;
    private $pages;

    public function __construct(
        $page
    ) {
        $this->page = $page;
    }

    /**
     * @inheritDoc
     */
    public function getPage(): ?CmsPageDataInterface
    {
        return $this->page;
    }

    /**
     * @inheritDoc
     */
    public function getItems(): ?array
    {
        return $this->pages;
    }

    public function setPages($pages = [])
    {
        $this->pages = $pages;
    }

}
