<?php
/**
 * Copyright (C) 2022 Novuna Consumer Finance
 * All rights reserved. See LICENCE.pdf for details
 */
declare(strict_types=1);

namespace Novuna\Pbf\Model\Data;

use Novuna\Pbf\Api\Data\DraftOrderDataInterface;
use Novuna\Pbf\Api\Data\DraftOrderWrapperInterface;

/**
 * @api
 */
class DraftOrderWrapper implements DraftOrderWrapperInterface
{

    private DraftOrderDataInterface $draftOrder;

    public function __construct(DraftOrderDataInterface $draftOrder)
    {
        $this->draftOrder = $draftOrder;
    }

    public function getDraftOrder(): ?\Novuna\Pbf\Api\Data\DraftOrderDataInterface
    {
        return $this->draftOrder;
    }
}
