<?php

/**
 * Copyright (C) 2022 Novuna Consumer Finance
 * All rights reserved. See LICENCE.pdf for details
 */

declare(strict_types=1);

namespace Novuna\Pbf\Model\Data;

use Novuna\Pbf\Api\Data\InstallationTokenDataInterface;

/**
 * @api
 */
class InstallationTokenData implements InstallationTokenDataInterface
{
    private string $pbfInstallHmac;

    public function __construct(
        string $pbfInstallHmac = null
    ) {
        $this->pbfInstallHmac = $pbfInstallHmac;
    }

    /**
     * @inheritDoc
     */
    public function getPbfInstallHmac(): ?string
    {
        return $this->pbfInstallHmac;
    }
}
