<?php

/**
 * Copyright (C) 2022 Novuna Consumer Finance
 * All rights reserved. See LICENCE.pdf for details
 */

declare(strict_types=1);

namespace Novuna\Pbf\Model\Data;

use Novuna\Pbf\Api\Data\InstallationTokenDataInterface;
use Novuna\Pbf\Api\Data\InstallationTokenWrapperInterface;

/**
 * @api
 */
class InstallationTokenWrapper implements InstallationTokenWrapperInterface
{
    private InstallationTokenDataInterface $installationToken;

    public function __construct(
        InstallationTokenDataInterface $installationToken = null
    ) {
        $this->installationToken = $installationToken;
    }

    /**
     * @inheritDoc
     */
    public function getInstallationToken(): InstallationTokenDataInterface
    {
        return $this->installationToken;
    }
}
