<?php
/**
 * Copyright (C) 2022 Novuna Consumer Finance
 * All rights reserved. See LICENCE.pdf for details
 */
declare(strict_types=1);

namespace Novuna\Pbf\Model\Data;

use Novuna\Pbf\Api\Data\OrderMetaFieldWrapperInterface;
use Novuna\Pbf\Api\Data\OrderMetaFieldDataInterface;

/**
 * @api
 */
class OrderMetaFieldWrapper implements OrderMetaFieldWrapperInterface
{
    /** @var OrderMetaFieldDataInterface */
    private $metaField;
    private $metaFields;

    public function __construct(
        OrderMetaFieldDataInterface $metaField = null
    ) {
        $this->metaField = $metaField;
    }

    /**
     * @return \Novuna\Pbf\Api\Data\OrderMetaFieldDataInterface|null
     */
    public function getMetaField(): ?\Novuna\Pbf\Api\Data\OrderMetaFieldDataInterface
    {
        return $this->metaField;
    }

    /**
     * @return \Novuna\Pbf\Api\Data\OrderMetaFieldDataInterface[]|null
     */
    public function getMetaFields(): ?array
    {
        return $this->metaFields ?? null;
    }

    /**
     * @param $metaFields
     * @return void
     */
    public function setMetaFields($metaFields = [])
    {
        $this->metaFields = $metaFields;
    }
}
