<?php

/**
 * Copyright (C) 2022 Novuna Consumer Finance
 * All rights reserved. See LICENCE.pdf for details
 */

declare(strict_types=1);

namespace Novuna\Pbf\Model\Data;

use Novuna\Pbf\Api\Data\OrderRiskWrapperInterface;

/**
 * @api
 */
class OrderRiskWrapper implements OrderRiskWrapperInterface
{
    private $items;
    private $item;

    public function __construct(
        array $items = null
    ) {
        $this->items = $items;
    }

    /**
     * @inheritDoc
     */
    public function getOrderRisks(): ?array
    {
        return $this->items;
    }

    /**
     * @inheritDoc
     */
    public function getOrderRisk(): ?\Novuna\Pbf\Api\Data\OrderRiskDataInterface
    {
        return $this->item;
    }

    public function setOrderRisk($orderRisk)
    {
        $this->item = $orderRisk;
    }

}
