<?php
/**
 * Copyright (C) 2022 Novuna Consumer Finance
 * All rights reserved. See LICENCE.pdf for details
 */
declare(strict_types=1);

namespace Novuna\Pbf\Model\Data;

use Novuna\Pbf\Api\Data\ProductMetaDataInterface;
use Novuna\Pbf\Api\Data\ProductMetaInterface;

/**
 * @api
 */
class ProductMeta implements ProductMetaInterface
{
    /** @var ProductMetaDataInterface[] */
    private $metaData;

    public function __construct(
        array $metaData = []
    ) {
        $this->metaData = $metaData;
    }

    /**
     * @return \Novuna\Pbf\Api\Data\ProductMetaDataInterface[]|null
     */
    public function getMetaData(): array
    {
        return $this->metaData;
    }
}
