<?php
/**
 * Copyright (C) 2022 Novuna Consumer Finance
 * All rights reserved. See LICENCE.pdf for details
 */
declare(strict_types=1);

namespace Novuna\Pbf\Model\Data;

use Novuna\Pbf\Api\Data\ScriptTagDataInterface;

/**
 * @api
 */
class ScriptTagData implements ScriptTagDataInterface
{

    private $createdAt;
    private $event;
    private $src;
    private $id;

    public function getCreatedAt(): ?string
    {
        return $this->createdAt;
    }

    public function setCreatedAt($createdAt)
    {
        return $this->createdAt = $createdAt;
    }

    public function getEvent(): ?string
    {
        return $this->event;
    }

    public function setEvent($event)
    {
        return $this->event = $event;
    }

    public function getSrc(): ?string
    {
        return $this->src;
    }

    public function setSrc($src)
    {
        return $this->src = $src;
    }

    public function getId(): ?int
    {
        return (int)$this->id;
    }

    public function setId($id)
    {
        return $this->id = $id;
    }
}
