<?php

namespace Novuna\Pbf\Model\Data;

use Novuna\Pbf\Api\Data\OrderMetaFieldDataInterface;

class SetOrderFinanceStateInput implements \Novuna\Pbf\Api\Data\SetOrderFinanceStateInputInterface
{

    private OrderMetaFieldDataInterface $metaField;
    private ?string $appnumber;
    private ?string $financestatestring;

    public function __construct(
        ?OrderMetaFieldDataInterface $metafield = null,
        ?string $appnumber = null,
        ?string $financestatestring = null
    ) {
        $this->metaField = $metafield;
        $this->appnumber = $appnumber;
        $this->financestatestring = $financestatestring;
    }

    public function getMetafield(
    ): ?\Novuna\Pbf\Api\Data\OrderMetaFieldDataInterface
    {
        return $this->metaField;
    }

    public function getAppnumber(): ?string
    {
        return $this->appnumber;
    }

    public function getFinancestatestring(): ?string
    {
        return $this->financestatestring;
    }
}
