<?php

/**
 * Copyright (C) 2022 Novuna Consumer Finance
 * All rights reserved. See LICENCE.pdf for details
 */

declare(strict_types=1);

namespace Novuna\Pbf\Model\Data;

use Novuna\Pbf\Api\Data\WebhookWrapperInterface;
use Novuna\Pbf\Api\Data\WebhookDataInterface;

/**
 * @api
 */
class WebhookWrapper implements WebhookWrapperInterface
{
    /** @var WebhookDataInterface[] */
    private $webhooks;

    public function __construct(
        array $webhooks = []
    ) {
        $this->webhooks = $webhooks;
    }

    /**
     * @inheritDoc
     */
    public function getWebhooks(): array
    {
        return $this->webhooks;
    }
}
