<?php
/**
 * Copyright (C) 2022 Novuna Consumer Finance
 * All rights reserved. See LICENCE.pdf for details
 */
declare(strict_types=1);

namespace Novuna\Pbf\Model\DraftOrder;

use Novuna\Pbf\Model\Config\AppConfig;
use Magento\Checkout\Model\ConfigProviderInterface;
use Magento\Checkout\Model\Session as CheckoutSession;
use Magento\Quote\Api\Data\CartInterface as Quote;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\Exception\NoSuchEntityException;

class AddressConfigProvider implements ConfigProviderInterface
{
    private CheckoutSession $checkoutSession;

    public function __construct(CheckoutSession $checkoutSession)
    {
        $this->checkoutSession = $checkoutSession;
    }

    public function getConfig(): array
    {
        $quote = $this->getQuote();
        $config['isDraftOrder'] = (bool)$quote->getData(AppConfig::DRAFT_ORDER_FLAG);

        return $config;
    }

    /**
     * @return Quote
     * @throws LocalizedException
     * @throws NoSuchEntityException
     */
    private function getQuote(): Quote
    {
        return $this->checkoutSession->getQuote();
    }
}
