<?php
/**
 * Copyright (C) 2022 Novuna Consumer Finance
 * All rights reserved. See LICENCE.pdf for details
 */
declare(strict_types=1);

namespace Novuna\Pbf\Model\DraftOrder;

use Novuna\Pbf\Model\Config\AppConfig;
use Magento\Framework\UrlInterface;
use Novuna\Pbf\Model\DraftOrder\Quote\QuoteIdManager;

class PaymentUrlGenerator
{
    const URL_PATH = 'checkout';
    const URL_PARAM_KEY = AppConfig::INBOUND_URL_PARAMETER;
    const URL_FRAGMENT = 'payment';

    private QuoteIdManager $quoteIdManager;
    private UrlInterface $url;

    public function __construct(QuoteIdManager $quoteIdManager, UrlInterface $url)
    {
        $this->quoteIdManager = $quoteIdManager;
        $this->url = $url;
    }

    public function generate(string $quoteId): string
    {
        if (! $this->quoteIdManager->isIdMasked($quoteId)) {
            $quoteId = $this->quoteIdManager->getMaskedById((int)$quoteId);
        }

        $url = $this->url->getBaseUrl();
        $url = $this->addPath($url);
        $url = $this->addParam($url, $quoteId);

        return $this->addFragment($url);
    }

    private function addPath(string $url): string
    {
        $url = rtrim($url, '/');
        $url .= '/' . self::URL_PATH . '/';

        return $url;
    }

    private function addParam(string $url, string $paramValue): string
    {
        return $url . '?' . http_build_query([self::URL_PARAM_KEY => $paramValue]);
    }

    private function addFragment(string $url): string
    {
        return $url . '#' . self::URL_FRAGMENT;
    }
}
