<?php
/**
 * Copyright (C) 2022 Novuna Consumer Finance
 * All rights reserved. See LICENCE.pdf for details
 */
declare(strict_types=1);

namespace Novuna\Pbf\Model\DraftOrder\Quote;

use Magento\Quote\Model\QuoteIdMaskFactory;
use Magento\Quote\Api\Data\CartInterface as Quote;
use Magento\Quote\Model\QuoteIdToMaskedQuoteIdInterface;
use Magento\Quote\Model\ResourceModel\Quote\QuoteIdMask as QuoteIdMaskResource;

class QuoteIdManager
{
    private QuoteIdMaskFactory $quoteIdMaskFactory;
    private QuoteIdToMaskedQuoteIdInterface $quoteIdToMaskedQuoteId;
    private QuoteIdMaskResource $quoteIdMaskResource;

    public function __construct(
        QuoteIdMaskFactory $quoteIdMaskFactory,
        QuoteIdToMaskedQuoteIdInterface $quoteIdToMaskedQuoteId,
        QuoteIdMaskResource $quoteIdMaskResource
    ) {
        $this->quoteIdMaskFactory = $quoteIdMaskFactory;
        $this->quoteIdToMaskedQuoteId = $quoteIdToMaskedQuoteId;
        $this->quoteIdMaskResource = $quoteIdMaskResource;
    }

    public function getMasked(Quote $quote): string
    {
        return $this->getMaskedById((int)$quote->getId());
    }

    public function getUnMasked(Quote $quote): string
    {
        return (string)$quote->getId();
    }

    public function getMaskedById(int $unMaskedId): string
    {
        $maskedId = $this->quoteIdToMaskedQuoteId->execute($unMaskedId);
        if ($maskedId == '') {
            $quoteIdMask = $this->quoteIdMaskFactory->create();
            $quoteIdMask->setQuoteId($unMaskedId);
            $this->quoteIdMaskResource->save($quoteIdMask);
            return $this->quoteIdToMaskedQuoteId->execute($unMaskedId);
        }
        return $maskedId;
    }

    public function getUnMaskedById(string $maskedId): string
    {
        $quoteIdMask = $this->quoteIdMaskFactory->create();
        $quoteIdMask->load($maskedId, 'masked_id');

        return $quoteIdMask->getQuoteId() ?: '';
    }

    public function isIdMasked(string $id): bool
    {

        return (bool)preg_match('/[a-zA-Z]/', $id);
    }
}
