<?php
/**
 * Copyright (C) 2022 Novuna Consumer Finance
 * All rights reserved. See LICENCE.pdf for details
 */
declare(strict_types=1);

namespace Novuna\Pbf\Model\DraftOrder\Quote;

use Magento\Quote\Api\Data\CartInterface as Quote;
use Novuna\Pbf\Model\Config\AppConfig;

class QuoteLocker
{
    public function isQuoteLocked(Quote $quote): bool
    {
        return (bool)$quote->getData(AppConfig::DRAFT_ORDER_FLAG);
    }

    public function lockQuote(Quote $quote): Quote
    {
        $quote->setData(AppConfig::DRAFT_ORDER_FLAG, true);
        $quote->setData('is_active', false);

        return $quote;
    }
}
