<?php
/**
 * Copyright (C) 2022 Novuna Consumer Finance
 * All rights reserved. See LICENCE.pdf for details
 */
declare(strict_types=1);

namespace Novuna\Pbf\Model\ResourceModel;

use Magento\Framework\Model\ResourceModel\Db\AbstractDb;

class DraftOrder extends AbstractDb
{
    /**
     * Initialize resource
     *
     * @return void
     */
    protected function _construct()
    {
        $this->_init('pbf_draft_order', 'id');
    }


    protected function _getLoadSelect($field, $value, $object)
    {
        $select = parent::_getLoadSelect(
            $field, $value, $object
        );

        $saleOrderTableName = $this->getConnection()->getTableName('sales_order');
        $select->joinLeft(
            ['o' => $saleOrderTableName],
            sprintf(
                '%s.%s = %s.%s',
                $this->_mainTable,
                'quote_id',
                'o',
                'quote_id'
            ),
            ['order_id' => 'entity_id']
        );

        return $select;
    }

    protected function _prepareDataForTable(\Magento\Framework\DataObject $object, $table) {
        $data = parent::_prepareDataForTable($object, $table);
        unset($data['order_id']);
        return $data;
    }

}
