<?php
/**
 * Copyright (C) 2022 Novuna Consumer Finance
 * All rights reserved. See LICENCE.pdf for details
 */
declare(strict_types=1);

namespace Novuna\Pbf\Model\ResourceModel\DraftOrder;

use Magento\Framework\Model\ResourceModel\Db\Collection\AbstractCollection;
use Magento\Framework\View\Element\UiComponent\DataProvider\SearchResult;
use Novuna\Pbf\Model\DraftOrder;
use Novuna\Pbf\Model\ResourceModel\DraftOrder as DraftOrderResource;

class Collection extends AbstractCollection
{
    /**
     * @var string
     */
    protected $_idFieldName = 'id';

    /**
     * Initialize resource
     */
    protected function _construct()
    {
        $this->_init(DraftOrder::class, DraftOrderResource::class);
        $this->_map['fields']['id'] = 'main_table.id';
    }

    protected function _initSelect()
    {
        parent::_initSelect();

        $saleOrderTableName = $this->getConnection()->getTableName('sales_order');
        $this->getSelect()->joinLeft(
            ['o' => $saleOrderTableName],
            sprintf(
                '%s.%s = %s.%s',
                $this->_mainTable,
                'quote_id',
                'o',
                'quote_id'
            ),
            ['order_id' => 'entity_id']
        );

    }


}
