<?php
/**
 * Copyright (C) 2022 Novuna Consumer Finance
 * All rights reserved. See LICENCE.pdf for details
 */
declare(strict_types=1);

namespace Novuna\Pbf\Model\Sales\Service;

use Psr\Log\LoggerInterface;
use Magento\Sales\Model\OrderNotifier;
use Magento\Framework\Api\FilterBuilder;
use Magento\Sales\Api\Data\OrderInterface;
use Magento\Framework\Event\ManagerInterface;
use Magento\Sales\Api\OrderRepositoryInterface;
use Magento\Sales\Api\PaymentFailuresInterface;
use Magento\Framework\Api\SearchCriteriaBuilder;
use Magento\Sales\Api\OrderStatusHistoryRepositoryInterface;
use Magento\Sales\Model\Order\Email\Sender\OrderCommentSender;

class OrderService extends \Magento\Sales\Model\Service\OrderService
{
    private FraudCheckService $fraudCheckService;

    public function __construct(
        OrderRepositoryInterface $orderRepository,
        OrderStatusHistoryRepositoryInterface $historyRepository,
        SearchCriteriaBuilder $criteriaBuilder,
        FilterBuilder $filterBuilder,
        OrderNotifier $notifier,
        ManagerInterface $eventManager,
        OrderCommentSender $orderCommentSender,
        PaymentFailuresInterface $paymentFailures,
        LoggerInterface $logger,
        FraudCheckService $fraudCheckService

    ) {
        parent::__construct(
            $orderRepository,
            $historyRepository,
            $criteriaBuilder,
            $filterBuilder,
            $notifier,
            $eventManager,
            $orderCommentSender,
            $paymentFailures,
            $logger
        );
        $this->fraudCheckService = $fraudCheckService;
    }

    /**
     * update order pbf fraud status
     *
     * @param OrderInterface $order
     * @return bool
     */
    public function acceptFraudRisk(OrderInterface $order): bool
    {
        $order->addCommentToStatusHistory(
            'PBF Risks accepted by M2 Admin user.'
        );
        $order->setPbfUserAcceptedFraud(true);
        $this->orderRepository->save($order);

        return true;
    }
}
