<?php
/**
 * Copyright (C) 2022 Novuna Consumer Finance
 * All rights reserved. See LICENCE.pdf for details
 */
declare(strict_types=1);

namespace Novuna\Pbf\Model\Total\Creditmemo;

use Magento\Sales\Model\Order\Creditmemo;
use Magento\Sales\Model\Order\Creditmemo\Total\AbstractTotal;
use Novuna\Pbf\Model\Utils\TotalCalculateUtils;

class FinanceAmount extends AbstractTotal
{
    /**
     * Add financed amount to totals so grandTotal ( = sum that will should refunded) will reflect the total
     * - financed amount (user payed only deposit)
     *
     * @param Creditmemo $creditmemo
     * @return $this
     * @SuppressWarnings(PHPMD.UnusedFormalParameter)
     */
    public function collect(Creditmemo $creditmemo)
    {
        $order = $creditmemo->getOrder();
        if ($order->getFinanceAmount() &&
            !TotalCalculateUtils::bcCompare(
                floatval($order->getFinanceAmountRefunded()),
                floatval($order->getFinanceAmount())
            )
        ) {
            $amount = abs(floatval($order->getFinanceAmount()));
            $baseAmount = abs(floatval($order->getBaseFinanceAmount()));
            if (TotalCalculateUtils::bcCompare($amount, 0)) {
                return $this;
            }

            $creditmemo->setFinanceAmount(-$amount);
            $creditmemo->setBaseFinanceAmount(-$baseAmount);

            $creditmemo->setGrandTotal($creditmemo->getGrandTotal() - $amount);
            $creditmemo->setBaseGrandTotal($creditmemo->getBaseGrandTotal() - $baseAmount);
        }

        return $this;
    }
}
