<?php

/**
 * Copyright (C) 2022 Novuna Consumer Finance
 * All rights reserved. See LICENCE.pdf for details
 */

declare(strict_types=1);

namespace Novuna\Pbf\Model;

use Magento\Framework\Model\AbstractModel;
use Novuna\Pbf\Api\Data\WebhookDataInterface;
use Novuna\Pbf\Model\Data\WebhookData;
use Novuna\Pbf\Model\ResourceModel\Webhook as WebhookResource;

class Webhook extends AbstractModel implements WebhookDataInterface
{
    /**
     * @inheritDoc
     */
    protected function _construct()
    {
        $this->_init(WebhookResource::class);
    }

    /**
     * @inheritDoc
     */
    public function getId(): ?string
    {
        $id = $this->getData(WebhookData::FIELD_ID);
        return $id ? (string)$id : null;
    }

    /**
     * @inheritDoc
     */
    public function setId($id)
    {
        return $this->setData(WebhookData::FIELD_ID, $id);
    }

    /**
     * @inheritDoc
     */
    public function getName(): ?string
    {
        return $this->getData(WebhookData::FIELD_NAME);
    }

    /**
     * @inheritDoc
     */
    public function setName(?string $name)
    {
        return $this->setData(WebhookData::FIELD_NAME, $name);
    }

    /**
     * @inheritDoc
     */
    public function getTopic(): ?string
    {
        return $this->getData(WebhookData::FIELD_TOPIC);
    }

    /**
     * @inheritDoc
     */
    public function setTopic(?string $topic)
    {
        return $this->setData(WebhookData::FIELD_TOPIC, $topic);
    }

    /**
     * @inheritDoc
     */
    public function getDeliveryUrl(): ?string
    {
        return $this->getData(WebhookData::FIELD_DELIVERY_URL);
    }

    /**
     * @inheritDoc
     */
    public function setDeliveryUrl(?string $deliveryUrl)
    {
        return $this->setData(WebhookData::FIELD_DELIVERY_URL, $deliveryUrl);
    }

    /**
     * @inheritDoc
     */
    public function getSecret(): ?string
    {
        return $this->getData(WebhookData::FIELD_SECRET);
    }

    /**
     * @inheritDoc
     */
    public function setSecret(?string $secret)
    {
        return $this->setData(WebhookData::FIELD_SECRET, $secret);
    }
}
