<?php
/**
 * Copyright (C) 2022 Novuna Consumer Finance
 * All rights reserved. See LICENCE.pdf for details
 */
declare(strict_types=1);

namespace Novuna\Pbf\Observer\Checkout;

use Magento\Checkout\Model\Session;
use Magento\Framework\Event\Observer;
use Magento\Framework\Event\ObserverInterface;

/**
 * When Customer logs in and there is pre-existing quote for him, Magento merges current "guest" quote with the
 * pre-existing customer quote. We copy PBF fields to the pre-existing quote.
 * It is not needed when there is no pre-existing customer quote. Strange.
 */
class QuoteMergeAfter implements ObserverInterface
{

    private Session $checkoutSession;

    public function __construct(Session $checkoutSession)
    {
        $this->checkoutSession = $checkoutSession;
    }

    public function execute(Observer $observer)
    {
        /* @var \Magento\Quote\Model\Quote $quote */
        $newQuote = $observer->getEvent()->getQuote();
        $sourceQuote = $observer->getEvent()->getSource();

        if ($sourceQuote->getFinanceEnabled()) {
            $newQuote->setFinanceEnabled($sourceQuote->getFinanceEnabled());
        }
    }
}
