<?php
/**
 * Copyright (C) 2022 Novuna Consumer Finance
 * All rights reserved. See LICENCE.pdf for details
 */
declare(strict_types=1);

namespace Novuna\Pbf\Observer\DraftOrder;

use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\Phrase;
use Novuna\Pbf\Model\Config\AppConfig;
use Magento\Framework\Event\Observer;
use Magento\Framework\Event\ObserverInterface;
use Magento\Quote\Model\Quote;

class BlockQuoteDelete implements ObserverInterface
{
    /**
     * @throws LocalizedException
     */
    public function execute(Observer $observer): void
    {
        $quote = $observer->getEvent()->getData('quote');
        if ($quote instanceof Quote) {
            if ($quote->getData(AppConfig::DRAFT_ORDER_FLAG)) {
                throw new LocalizedException(
                    new Phrase(
                        'Cannot delete draft order quote'
                    )
                );
            }
        }
    }
}
