<?php
/**
 * Copyright (C) 2022 Novuna Consumer Finance
 * All rights reserved. See LICENCE.pdf for details
 */
declare(strict_types=1);

namespace Novuna\Pbf\Plugin\Pricing;

use Magento\Catalog\Model\Product;
use Magento\Framework\Pricing\SaleableInterface;

class Render
{
    public function afterRender(
        \Magento\Framework\Pricing\Render $subject,
        $priceRenderHtml,
        $priceCode,
        SaleableInterface $saleableItem,
        array $arguments = []
    ) {
        if ($saleableItem instanceof Product && $priceCode == 'final_price') {
            $priceRenderHtml .= $this->getPbfMetaPriceTagHtml($saleableItem);
        }

        return $priceRenderHtml;
    }

    private function getPbfMetaPriceTagHtml(Product $saleableItem): string
    {
        $tagHtml = '';
        if ($saleableItem->getPaybyfinanceEnable() !== 2) {
            $tagHtml = "<div class='finance-from-product' 
            data-pbf-item-id='" . $saleableItem->getId() . "'
            data-pbf-final-price='" . $saleableItem->getFinalPrice() . "'
            ></div>";
        }

        return $tagHtml;
    }
}
