<?php
/**
 * Copyright (C) 2022 Novuna Consumer Finance
 * All rights reserved. See LICENCE.pdf for details
 */
declare(strict_types=1);

namespace Novuna\Pbf\Ui\DraftOrder\Component\Column;

use Novuna\Pbf\Model\DraftOrder\PaymentUrlGenerator;
use Magento\Ui\Component\Listing\Columns\Column;
use Magento\Framework\View\Element\UiComponent\ContextInterface;
use Magento\Framework\View\Element\UiComponentFactory;

class PaymentUrl extends Column
{
    private PaymentUrlGenerator $inboundUrlGenerator;

    public function __construct(
        PaymentUrlGenerator $inboundUrlGenerator,
        ContextInterface $context,
        UiComponentFactory $uiComponentFactory,
        array $components = [],
        array $data = []
    ) {
        parent::__construct($context, $uiComponentFactory, $components, $data);

        $this->inboundUrlGenerator = $inboundUrlGenerator;
    }

    public function prepareDataSource(array $dataSource): array
    {
        if (isset($dataSource['data']['items'])) {
            foreach ($dataSource['data']['items'] as & $item) {
                $url = $this->inboundUrlGenerator->generate($item['quote_id']);
                $item['payment_url'] = '<a href="' . $url . '">' . $url . '</a>';
            }
        }

        return $dataSource;
    }
}
