/**
 * Copyright (C) 2022 Novuna Consumer Finance
 * All rights reserved. See LICENCE.pdf for details
 */
define([
    'jquery',
    'mage/storage'
], function ($, storage) {
    'use strict';

    return function (data) {
        let self = this;

        $(document).ready(function () {
            let pbfProductMeta = {};
            $('.finance-from-product').each(function (i) {
                let priceInfo = {};
                let prodId = $(this).data('pbf-item-id');
                let price = $(this).data('pbf-final-price');
                if ($('#product-price-' + prodId).length) {
                    price = $('#product-price-' + prodId).data('price-amount');
                }
                priceInfo['price'] = Math.round(price);
                pbfProductMeta[prodId] = priceInfo;
            });

            let deferred = $.Deferred();
            let serviceUrl = 'pbfwidget/getFinanceFrom';
            let self = this;
            return storage.post(
                serviceUrl,
                JSON.stringify(pbfProductMeta),
                false
            ).done(function (response) {
                $.each(response, function(index, item) {

                    if($('[data-pbf-item-id='+index+']').length && item.min_installment !== null){
                        $('[data-pbf-item-id='+index+']').html("Finance available from £" + item.min_installment + " per month*");
                    }
                });

                deferred.resolve();
            }).fail(function (response) {
                deferred.reject();
            });
        });
        return self;
    };

});
