<?php
/**
 * Copyright (C) 2022 Novuna Consumer Finance
 * All rights reserved. See LICENCE.pdf for details
 */
declare(strict_types=1);

namespace Novuna\Pbf\Api;

use Magento\Framework\Api\SearchCriteriaInterface;
use Magento\Framework\Exception\NoSuchEntityException;
use Novuna\Pbf\Api\Data\DraftOrderDataInterface;
use Novuna\Pbf\Model\ResourceModel\SalesOrderMeta\Collection;

/**
 * CRUD interface.
 * @api
 * @since 100.0.2
 */
interface DraftOrderRepositoryInterface
{
    /**
     *
     * @param \Novuna\Pbf\Api\Data\DraftOrderDataInterface $draftOrder
     * @return \Novuna\Pbf\Api\Data\DraftOrderDataInterface
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function save(Data\DraftOrderDataInterface $draftOrder);

    /**
     *
     * @param string $draftOrderId
     * @return \Novuna\Pbf\Api\Data\DraftOrderDataInterface
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function getById($draftOrderId);

    /**
     * @param string $quoteId
     * @return \Novuna\Pbf\Api\Data\DraftOrderDataInterface
     */
    public function getByQuoteId($quoteId);

    /**
     * @return Collection
     */
    public function getCollection();

    /**
     *
     * @param SearchCriteriaInterface $searchCriteria
     * @return \Magento\Framework\Api\SearchResultsInterface
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function getList(SearchCriteriaInterface $searchCriteria);

    /**
     *
     * @param \Novuna\Pbf\Api\Data\DraftOrderDataInterface $draftOrder
     * @return bool true on success
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function delete(Data\DraftOrderDataInterface $draftOrder);

    /**
     *
     * @param string $draftOrderId
     * @return bool true on success
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function deleteById($draftOrderId);
}
