<?php
/**
 * Copyright (C) 2022 Novuna Consumer Finance
 * All rights reserved. See LICENCE.pdf for details
 */
declare(strict_types=1);

namespace Novuna\Pbf\Block\Adminhtml\Installation\Widget;

use Magento\Backend\Block\Widget\Form\Generic;

class Info extends Generic
{
    /**#@+
     * Form elements names.
     */
    const HTML_ID_PREFIX = 'pbf_integration_properties_';

    const DATA_CONSUMER_PASSWORD = 'current_password';

    /**#@-*/

    /**
     * Set form id prefix, declare fields for integration info
     *
     * @return $this
     */
    protected function _prepareForm()
    {
        /** @var \Magento\Framework\Data\Form $form */
        $form = $this->_formFactory->create();
        $form->setHtmlIdPrefix(self::HTML_ID_PREFIX);
        $this->addGeneralFieldset($form);
        $this->setForm($form);
        return $this;
    }

    protected function addGeneralFieldset($form)
    {
        $currentUserVerificationFieldset = $form->addFieldset(
            'current_user_verification_fieldset',
            ['legend' => __('Current User Identity Verification')]
        );
        $currentUserVerificationFieldset->addField(
            self::DATA_CONSUMER_PASSWORD,
            'password',
            [
                'name' => self::DATA_CONSUMER_PASSWORD,
                'label' => __('Your Password'),
                'id' => self::DATA_CONSUMER_PASSWORD,
                'title' => __('Your Password'),
                'class' => 'validate-current-password required-entry',
                'required' => true
            ]
        );
    }
}
