<?php
/**
 * Copyright (C) 2022 Novuna Consumer Finance
 * All rights reserved. See LICENCE.pdf for details
 */
declare(strict_types=1);


namespace Novuna\Pbf\Block\Adminhtml\Postdata;

use Magento\Integration\Api\IntegrationServiceInterface;
use Magento\Integration\Api\OauthServiceInterface;
use Novuna\Pbf\Model\StoreConfigProvider;
use Novuna\Pbf\Model\Widget\PbfWidgetConfigProvider;
use Novuna\Pbf\Helper\Data as Helper;


class Index extends \Magento\Backend\Block\Template
{
    private PbfWidgetConfigProvider $pbfWidgetConfigProvider;
    private OauthServiceInterface $oauthService;
    private IntegrationServiceInterface $integrationService;

    /**
     * Constructor
     *
     * @param \Magento\Backend\Block\Template\Context  $context
     * @param array $data
     */
    public function __construct(
        PbfWidgetConfigProvider $pbfWidgetConfigProvider,
        \Magento\Backend\Block\Template\Context $context,
        OauthServiceInterface $oauthService,
        IntegrationServiceInterface $integrationService,
        array $data = []
    ) {
        parent::__construct($context, $data);
        $this->pbfWidgetConfigProvider = $pbfWidgetConfigProvider;
        $this->oauthService = $oauthService;
        $this->integrationService = $integrationService;
    }

    public function composeRequestURL() {
        $orderid = $this->getRequest()->getParam('order_id');
        $shopDomain = $this->pbfWidgetConfigProvider->getShopDomain();
        $appServerUrl = $this->pbfWidgetConfigProvider->getAppServerUrl();

        $url = $appServerUrl . '/magento/financeDetails?id=' . $orderid . '&shop=' . $shopDomain;
        $params = [];
        parse_str(parse_url($url)['query'], $params);
        $integrationName = StoreConfigProvider::PBF_INTEGRATION_IDENTIFIER;
        $integration = $this->integrationService->findByName($integrationName);
        $accessToken = $this->oauthService->getAccessToken($integration->getConsumerId());

        $now = new \DateTime();
        $params['timestamp'] = $now->getTimestamp();
        $params["hmac"] = Helper::calculateHMAC($params, $accessToken->getSecret());
        $params["sv"] = $this->pbfWidgetConfigProvider->getPbfServerVersion();

        return $appServerUrl . '/magento/financeDetails' . "?" . http_build_query($params);
    }
}

