<?php
/**
 * Copyright (C) 2022 Novuna Consumer Finance
 * All rights reserved. See LICENCE.pdf for details
 */
declare(strict_types=1);

namespace Novuna\Pbf\Block\Totals\Order;

use Magento\Framework\DataObject;
use Magento\Framework\View\Element\Template;
use Novuna\Pbf\Model\Utils\TotalCalculateUtils;

class PbfDeposit extends Template
{
    /**
     * Initialization of totals for admin view of order
     * @return void
     */
    public function initTotals()
    {
        $parent = $this->getParentBlock();
        $source = $parent->getSource();
        if ($source->getPbfFinanceAmount() != 0) {
            $financeAmount = abs(floatval($source->getPbfFinanceAmount()));
            $baseFinanceAmount = abs(floatval($source->getPbfBaseFinanceAmount()));

            $financedAmount = new DataObject(
                [
                    'code' => 'pbf_financed_amount',
                    'value' => -$financeAmount,
                    'base_value' => -$baseFinanceAmount,
                    'label' => __('Financed Amount'),
                ]
            );

            $parent->addTotalBefore($financedAmount, 'grand_total');
        }
    }
}
